const { execSync } = require('child_process');
const fs = require('fs');

const packageJson = JSON.parse(fs.readFileSync('package.json', 'utf8'));
const version = packageJson.version;

const commands = [
  `npx electron-packager . GasCraft-Launcher-${version} --platform=win32 --arch=x64`,
  `npx electron-packager . GasCraft-Launcher-${version} --platform=darwin --arch=arm64`
];

commands.forEach(cmd => {
  console.log(`Running: ${cmd}`);
  execSync(cmd, { stdio: 'inherit' });
});